/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerDefinition;
import com.tiviacz.travelersbackpack.client.model.FluidModelPart;
import com.tiviacz.travelersbackpack.client.model.StackModelPart;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackLayerModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final BackpackLayerModel<?> LAYER_MODEL = new BackpackLayerModel(BackpackLayerDefinition.createTravelersBackpack(true).m_171564_());
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;
    public StackModelPart stacks;
    public FluidModelPart fluids;
    @Nullable
    private ItemStack backpackStack;
    @Nullable
    private LivingEntity livingEntity;
    @Nullable
    private MultiBufferSource buffer;

    public BackpackLayerModel(ModelPart rootPart) {
        super(rootPart);
        this.mainBody = rootPart.m_171324_("body").m_171324_("main_body");
        this.tankLeftTop = rootPart.m_171324_("body").m_171324_("tankLeftTop");
        this.tankRightTop = rootPart.m_171324_("body").m_171324_("tankRightTop");
        this.sleepingBag = rootPart.m_171324_("body").m_171324_("sleepingBag");
        this.sleepingBagExtras = rootPart.m_171324_("body").m_171324_("sleepingBagExtras");
        this.villagerNose = rootPart.m_171324_("body").m_171324_("villagerNose");
        this.ocelotNose = rootPart.m_171324_("body").m_171324_("ocelotNose");
        this.pigNose = rootPart.m_171324_("body").m_171324_("pigNose");
        this.foxNose = rootPart.m_171324_("body").m_171324_("foxNose");
        this.wolfNose = rootPart.m_171324_("body").m_171324_("wolfNose");
        this.stacks = new StackModelPart(rootPart.m_171324_("body").m_171324_("stacks"));
        this.fluids = new FluidModelPart(rootPart.m_171324_("body").m_171324_("fluids"));
    }

    public void setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    public void setMultiBufferSource(MultiBufferSource buffer) {
        this.buffer = buffer;
    }

    public void setBackpackStack(ItemStack stack) {
        this.backpackStack = stack;
    }

    public ItemStack getBackpackStack() {
        if (this.backpackStack != null && this.backpackStack.m_41720_() instanceof TravelersBackpackItem) {
            return this.backpackStack;
        }
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return CapabilityUtils.getWearingBackpack(player);
        }
        return this.livingEntity.m_6844_(EquipmentSlot.CHEST);
    }

    public void setupAngles(HumanoidModel model) {
        this.mainBody.m_104315_(model.f_102810_);
        this.sleepingBag.m_104315_(model.f_102810_);
        this.sleepingBagExtras.m_104315_(model.f_102810_);
        this.tankLeftTop.m_104315_(model.f_102810_);
        this.tankRightTop.m_104315_(model.f_102810_);
        this.villagerNose.m_104315_(model.f_102810_);
        this.pigNose.m_104315_(model.f_102810_);
        this.ocelotNose.m_104315_(model.f_102810_);
        this.wolfNose.m_104315_(model.f_102810_);
        this.foxNose.m_104315_(model.f_102810_);
        if (this.livingEntity instanceof Player) {
            this.stacks.m_104315_(model.f_102810_);
            this.fluids.m_104315_(model.f_102810_);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        LivingEntity livingEntity;
        this.sleepingBag.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.sleepingBagExtras.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.tankLeftTop.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.tankRightTop.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.mainBody.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        if (this.livingEntity != null) {
            Item item = this.getBackpackStack().m_41720_();
            if (item == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
            if (item == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
            if (item == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
            if (item == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
            if (item == ModItems.PIG_TRAVELERS_BACKPACK.get() || item == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
        }
        if ((livingEntity = this.livingEntity) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.buffer != null) {
                if (((Boolean)TravelersBackpackConfig.CLIENT.renderTools.get()).booleanValue()) {
                    this.stacks.prepare(this.getBackpackStack(), player, this.buffer);
                    this.stacks.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
                }
                this.fluids.prepare(this.getBackpackStack(), this.buffer);
                this.fluids.m_104301_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn);
            }
        }
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_);
    }
}

